/**
 * Mupen64 - r4300/x86_64/gcop1.c
 * Copyright (C) 2007 Richard Goedeken, Hacktarux
 * Based on code written by Hacktarux, Copyright (C) 2002
 *
 * Mupen64 homepage: http://mupen64.emulation64.com
 * Forum homepage: http://www.emutalk.net/forumdisplay.php?f=50
 * 
 * This program is free software; you can redistribute it and/
 * or modify it under the terms of the GNU General Public Li-
 * cence as published by the Free Software Foundation; either
 * version 2 of the Licence, or any later version.
 *
 * This program is distributed in the hope that it will be use-
 * ful, but WITHOUT ANY WARRANTY; without even the implied war-
 * ranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public Licence for more details.
 *
 * You should have received a copy of the GNU General Public
 * Licence along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *
**/


#include <stdio.h>
#include "../recomph.h"
#include "../recomp.h"
#include "assemble.h"
#include "../r4300.h"
#include "../ops.h"
#include "../../memory/memory.h"
#include "../macros.h"
#include "interpret.h"

void genmfc1()
{
#if defined(COUNT_INSTR)
   inc_m32abs(&instr_count[111]);
#endif
#ifdef INTERPRET_MFC1
   gencallinterp((unsigned long long)MFC1, 0);
#else
   gencheck_cop1_unusable();
   mov_reg64_m64abs(RAX, (unsigned long long *)(&reg_cop1_simple[dst->f.r.nrd]));
   mov_reg32_preg64(EBX, RAX);
   mov_m32abs_reg32((unsigned int*)dst->f.r.rt, EBX);
   sar_reg32_imm8(EBX, 31);
   mov_m32abs_reg32(((unsigned int*)dst->f.r.rt)+1, EBX);
#endif
}

void gendmfc1()
{
#if defined(COUNT_INSTR)
   inc_m32abs(&instr_count[112]);
#endif
#ifdef INTERPRET_DMFC1
   gencallinterp((unsigned long long)DMFC1, 0);
#else
   gencheck_cop1_unusable();
   mov_reg64_m64abs(RAX, (unsigned long long *) (&reg_cop1_double[dst->f.r.nrd]));
   mov_reg32_preg64(EBX, RAX);
   mov_reg32_preg64pimm32(ECX, RAX, 4);
   mov_m32abs_reg32((unsigned int*)dst->f.r.rt, EBX);
   mov_m32abs_reg32(((unsigned int*)dst->f.r.rt)+1, ECX);
#endif
}

void gencfc1()
{
#if defined(COUNT_INSTR)
   inc_m32abs(&instr_count[113]);
#endif
#ifdef INTERPRET_CFC1
   gencallinterp((unsigned long long)CFC1, 0);
#else
   gencheck_cop1_unusable();
   if(dst->f.r.nrd == 31) mov_reg32_m32abs(EAX, (unsigned int*)&FCR31);
   else mov_reg32_m32abs(EAX, (unsigned int*)&FCR0);
   mov_m32abs_reg32((unsigned int*)dst->f.r.rt, EAX);
   sar_reg32_imm8(EAX, 31);
   mov_m32abs_reg32(((unsigned int*)dst->f.r.rt)+1, EAX);
#endif
}

void genmtc1()
{
#if defined(COUNT_INSTR)
   inc_m32abs(&instr_count[114]);
#endif
#ifdef INTERPRET_MTC1
   gencallinterp((unsigned long long)MTC1, 0);
#else
   gencheck_cop1_unusable();
   mov_reg32_m32abs(EAX, (unsigned int*)dst->f.r.rt);
   mov_reg64_m64abs(RBX, (unsigned long long *)(&reg_cop1_simple[dst->f.r.nrd]));
   mov_preg64_reg32(RBX, EAX);
#endif
}

void gendmtc1()
{
#if defined(COUNT_INSTR)
   inc_m32abs(&instr_count[115]);
#endif
#ifdef INTERPRET_DMTC1
   gencallinterp((unsigned long long)DMTC1, 0);
#else
   gencheck_cop1_unusable();
   mov_reg32_m32abs(EAX, (unsigned int*)dst->f.r.rt);
   mov_reg32_m32abs(EBX, ((unsigned int*)dst->f.r.rt)+1);
   mov_reg64_m64abs(RDX, (unsigned long long *)(&reg_cop1_double[dst->f.r.nrd]));
   mov_preg64_reg32(RDX, EAX);
   mov_preg64pimm32_reg32(RDX, 4, EBX);
#endif
}

void genctc1()
{
#if defined(COUNT_INSTR)
   inc_m32abs(&instr_count[116]);
#endif
#ifdef INTERPRET_CTC1
   gencallinterp((unsigned long long)CTC1, 0);
#else
   gencheck_cop1_unusable();
   
   if (dst->f.r.nrd != 31) return;
   mov_reg32_m32abs(EAX, (unsigned int*)dst->f.r.rt);
   mov_m32abs_reg32((unsigned int*)&FCR31, EAX);
   and_eax_imm32(3);
   
   cmp_eax_imm32(0);
   jne_rj(13);
   mov_m32abs_imm32((unsigned int*)&rounding_mode, 0x33F); // 11
   jmp_imm_short(51); // 2
   
   cmp_eax_imm32(1); // 5
   jne_rj(13); // 2
   mov_m32abs_imm32((unsigned int*)&rounding_mode, 0xF3F); // 11
   jmp_imm_short(31); // 2
   
   cmp_eax_imm32(2); // 5
   jne_rj(13); // 2
   mov_m32abs_imm32((unsigned int*)&rounding_mode, 0xB3F); // 11
   jmp_imm_short(11); // 2
   
   mov_m32abs_imm32((unsigned int*)&rounding_mode, 0x73F); // 11
   
   fldcw_m16abs((unsigned short*)&rounding_mode);
#endif
}
